<?php
require 'config.php';
session_start();

if (!isset($_SESSION['professeur_id'])) {
    header('Location: connexion.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nom_complet = $_POST['nom_complet'];
    $email = $_POST['email'];
    $mot_de_passe = password_hash($_POST['mot_de_passe'], PASSWORD_DEFAULT);
    $tel = $_POST['tel'];

    $stmt = $pdo->prepare("INSERT INTO eleves (nom_complet, email, mot_de_passe, tel, professeur_id, id_professeur) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$nom_complet, $email, $mot_de_passe, $tel, $_SESSION['professeur_id'], 0]);

    echo "Élève ajouté avec succès!";
}

// Récupérer les élèves existants pour affichage
$professeur_id = $_SESSION['professeur_id'];
$stmt = $pdo->prepare("SELECT * FROM eleves WHERE professeur_id = ?");
$stmt->execute([$professeur_id]);
$eleves = $stmt->fetchAll();

if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM eleves WHERE id = ?");
    $stmt->execute([$id]);
    header('Location: ajouter_eleve.php');
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Ajouter un Élève</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            width: 80%;
            margin: auto;
            overflow: hidden;
        }
        h1 {
            text-align: center;
        }
        form {
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: auto;
        }
        form input[type="text"], form input[type="email"], form input[type="password"], form input[type="tel"] {
            width: calc(100% - 22px);
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        form button {
            background-color: #007bff;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
        }
        form button:hover {
            background-color: #0056b3;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            background: #fff;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f4f4f4;
        }
        a {
            color: #007bff;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <?php include 'menu.php'; ?>
    <div class="container">
        <h1>Ajouter un Élève</h1>
        <form method="POST" action="ajouter_eleve.php">
            <label for="nom_complet">Nom Complet:</label>
            <input type="text" name="nom_complet" required>
            <label for="email">Email:</label>
            <input type="email" name="email" required>
            <label for="mot_de_passe">Mot de Passe:</label>
            <input type="password" name="mot_de_passe" required>
            <label for="tel">Téléphone:</label>
            <input type="tel" name="tel">
            <button type="submit">Ajouter Élève</button>
        </form>

        <h2>Liste des Élèves</h2>
        <table>
            <tr>
                <th>Nom Complet</th>
                <th>Email</th>
                <th>Téléphone</th>
                <th>Actions</th>
            </tr>
            <?php foreach ($eleves as $eleve): ?>
            <tr>
                <td><?php echo htmlspecialchars($eleve['nom_complet']); ?></td>
                <td><?php echo htmlspecialchars($eleve['email']); ?></td>
                <td><?php echo htmlspecialchars($eleve['tel']); ?></td>
                <td><a href="ajouter_eleve.php?delete=<?php echo $eleve['id']; ?>" onClick="return confirm('Êtes-vous sûr de vouloir supprimer cet élève ?')">Supprimer</a></td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
