<?php
require 'config.php'; // Connexion  la base de donnes
session_start();

if (!isset($_SESSION['professeur_id'])) {
    header('Location: connexion.php');
    exit;
}

$professeur_id = $_SESSION['professeur_id'];

// Rcuprer les cours du professeur
$stmt = $pdo->prepare("SELECT * FROM cours WHERE professeur_id = ?");
$stmt->execute([$professeur_id]);
$cours = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Grer les Cours</title>
    <link rel="stylesheet" href="style.css"> <!-- Assurez-vous que vous avez un fichier CSS pour le style -->
</head>
<body>
    <h1>Grer les Cours</h1>
    <table border="1">
        <thead>
            <tr>
                <th>Titre</th>
                <th>Description</th>
                <th>Vido</th>
                <th>PDF</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($cours as $course): ?>
                <tr>
                    <td><?php echo htmlspecialchars($course['titre']); ?></td>
                    <td><?php echo htmlspecialchars($course['description']); ?></td>
                    <td>
                        <?php if ($course['url_video']): ?>
                            <iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo htmlspecialchars(parse_url($course['url_video'], PHP_URL_QUERY)); ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($course['pdf']): ?>
                            <a href="uploads/<?php echo htmlspecialchars($course['pdf']); ?>" target="_blank">Tlcharger le PDF</a>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="modifier_cours.php?id=<?php echo $course['id']; ?>">Modifier</a>
                        <a href="supprimer_cours.php?id=<?php echo $course['id']; ?>">Supprimer</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <a href="dashboard.php">Retour au Tableau de Bord</a>
</body>
</html>
