<?php
require 'config.php';
session_start();

if (!isset($_SESSION['professeur_id'])) {
    header('Location: connexion.php');
    exit;
}

$professeur_id = $_SESSION['professeur_id'];

$stmt = $pdo->prepare("SELECT * FROM cours WHERE professeur_id = ? AND pdf IS NOT NULL");
$stmt->execute([$professeur_id]);
$cours_pdf = $stmt->fetchAll();

if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("SELECT pdf FROM cours WHERE id = ?");
    $stmt->execute([$id]);
    $file = $stmt->fetchColumn();

    if ($file) {
        unlink("uploads/" . $file);
        $stmt = $pdo->prepare("DELETE FROM cours WHERE id = ?");
        $stmt->execute([$id]);
        header('Location: gerer_cours_pdf.php');
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gérer les Cours PDF</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 80%;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin-top: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #007bff;
            color: white;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        a {
            color: #007bff;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
        .actions {
            text-align: center;
        }
        .actions a {
            margin: 0 5px;
            color: #dc3545;
        }
        .actions a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <?php include 'menu.php'; ?>
    <div class="container">
        <h1>Gérer les Cours PDF</h1>
        <table>
            <tr>
                <th>Titre</th>
                <th>PDF</th>
                <th>Actions</th>
            </tr>
            <?php foreach ($cours_pdf as $cours): ?>
            <tr>
                <td><?php echo htmlspecialchars($cours['titre']); ?></td>
                <td><a href="uploads/<?php echo htmlspecialchars($cours['pdf']); ?>" target="_blank">Voir PDF</a></td>
                <td class="actions">
                    <a href="gerer_cours_pdf.php?delete=<?php echo $cours['id']; ?>" onClick="return confirm('Êtes-vous sûr de vouloir supprimer ce PDF ?')">Supprimer</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
