<?php
require 'config.php'; // Assurez-vous que ce chemin est correct

session_start(); // Démarrage de la session

if (!isset($_SESSION['professeur_id'])) {
    // Redirection vers la page de connexion si la session n'existe pas
    header('Location: connexion.php');
    exit;
}

$professeur_id = $_SESSION['professeur_id'];

// Connexion à la base de données déjà établie dans config.php

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $titre = $_POST['titre'] ?? '';
    $contenu = $_POST['contenu'] ?? '';

    try {
        // Préparer et exécuter la requête d'insertion
        $sql = "INSERT INTO messages (id_professeur, titre, contenu, date_envoi) VALUES (:id_professeur, :titre, :contenu, NOW())";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id_professeur', $professeur_id);
        $stmt->bindParam(':titre', $titre);
        $stmt->bindParam(':contenu', $contenu);
        $stmt->execute();

        // Message de succès
        $message = 'Message envoyé avec succès.';
    } catch (PDOException $e) {
        $message = 'Erreur lors de l\'envoi du message : ' . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Envoyer un Message</title>
    <link rel="stylesheet" href="../style.css"> <!-- Assurez-vous que ce chemin est correct -->
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 80%;
            margin: 0 auto;
            padding: 20px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h2 {
            color: #007bff;
            text-align: center;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        label {
            margin-bottom: 5px;
            font-weight: bold;
        }
        input, textarea {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
        }
        textarea {
            height: 150px;
            resize: vertical;
        }
        button {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background-color: #0056b3;
        }
        .message {
            margin: 15px 0;
            text-align: center;
            font-weight: bold;
            color: #007bff;
        }
    </style>
</head>
<body>
    <?php include 'menu.php'; ?>

    <div class="container">
        <h2>Envoyer un message aux élèves</h2>

        <?php if (isset($message)): ?>
            <div class="message"><?php echo htmlspecialchars($message); ?></div>
        <?php endif; ?>

        <form method="post" action="">
            <label for="titre">Titre du message :</label>
            <input type="text" id="titre" name="titre" required>
            <label for="contenu">Contenu du message :</label>
            <textarea id="contenu" name="contenu" rows="5" required></textarea>
            <button type="submit">Envoyer</button>
        </form>
    </div>
</body>
</html>
