<?php
// Inclure le fichier de configuration pour la connexion  la base de donnes
require 'config.php';
session_start(); // Dmarrer la session

// Vrification de la session pour les professeurs
if (!isset($_SESSION['professeur_id'])) {
    header('Location: connexion.php');
    exit;
}

// Vrifier si la connexion  la base de donnes est tablie
if (!isset($pdo)) {
    die('Erreur de connexion  la base de donnes.');
}

// Vrifier si un ID de vido a t fourni
if (isset($_POST['video_id'])) {
    $videoId = $_POST['video_id'];

    // Supprimer la vido de la base de donnes
    $sql = "DELETE FROM videos WHERE id = :video_id AND professeur_id = :professeur_id";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':video_id', $videoId, PDO::PARAM_INT);
    $stmt->bindValue(':professeur_id', $_SESSION['professeur_id'], PDO::PARAM_INT);
    $stmt->execute();

    // Rediriger vers la page de gestion des vidos
    header('Location: gerer_videos.php');
    exit;
} else {
    // Si aucun ID n'a t fourni, rediriger vers la page de gestion des vidos
    header('Location: gerer_videos.php');
    exit;
}
