<?php
require 'config.php'; // Connexion à la base de données
session_start();

// Vérifiez si l'utilisateur (élève) est connecté
if (!isset($_SESSION['eleve_id'])) {
    header('Location: connexion_eleve.php'); // Redirigez vers la page de connexion s'ils ne sont pas connectés
    exit;
}

// Récupérer le professeur_id associé à l'élève connecté
$eleve_id = $_SESSION['eleve_id'];
$professeur_stmt = $pdo->prepare("SELECT professeur_id FROM eleves WHERE id = :eleve_id");
$professeur_stmt->bindValue(':eleve_id', $eleve_id, PDO::PARAM_INT);
$professeur_stmt->execute();
$professeur_id = $professeur_stmt->fetchColumn();

if (!$professeur_id) {
    die("Professeur non trouvé pour cet élève.");
}

// Configuration de la pagination
$cours_par_page = 9; // Nombre de cours à afficher par page
$page_courante = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page_courante - 1) * $cours_par_page;

// Requête pour récupérer les fichiers PDF pour le professeur associé
$stmt = $pdo->prepare("SELECT * FROM fiches_pdf WHERE professeur_id = :professeur_id ORDER BY date_ajout DESC LIMIT :limit OFFSET :offset");
$stmt->bindValue(':professeur_id', $professeur_id, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':limit', $cours_par_page, PDO::PARAM_INT);

if (!$stmt->execute()) {
    print_r($stmt->errorInfo()); // Afficher les erreurs SQL
}

$fiches_pdf = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Calculer le nombre total de cours pour la pagination
$total_cours_stmt = $pdo->prepare("SELECT COUNT(*) FROM fiches_pdf WHERE professeur_id = :professeur_id");
$total_cours_stmt->bindValue(':professeur_id', $professeur_id, PDO::PARAM_INT);
$total_cours_stmt->execute();
$total_cours = $total_cours_stmt->fetchColumn();
$total_pages = ceil($total_cours / $cours_par_page);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Cours PDF</title>
    <link rel="stylesheet" href="../style.css"> <!-- Assurez-vous que le fichier CSS est correctement lié -->
    <style>
        .gallery {
            display: grid;
            grid-template-columns: repeat(3, 1fr); /* 3 colonnes de taille égale */
            gap: 20px; /* Espacement entre les éléments */
            margin-top: 20px;
        }

        .pdf-item {
            text-align: center;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .pdf-item img {
            width: 100px;
            height: 100px;
        }

        .pagination {
            margin-top: 20px;
            text-align: center;
        }

        .pagination a {
            margin: 0 5px;
            padding: 10px 15px;
            text-decoration: none;
            color: #333;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .pagination a.active {
            background-color: #007bff;
            color: #fff;
            border-color: #007bff;
        }
    </style>
</head>
<body>
    <?php 
    // Inclure le menu avec vérification de l'existence
    $menu_path = 'menu.php'; // Chemin relatif au fichier menu.php
    if (file_exists($menu_path)) {
        include $menu_path;
    } else {
        echo "<p>Menu non trouvé. Vérifiez le chemin d'accès.</p>";
    }
    ?>
    <div class="content">
        <h1>Cours en PDF</h1>
        <div class="gallery">
            <?php foreach ($fiches_pdf as $pdf): ?>
                <div class="pdf-item">
                    <?php if (isset($pdf['pdf']) && !empty($pdf['pdf'])): ?>
                        <?php
                        $file_path = "../admin/uploads/" . htmlspecialchars($pdf['pdf']); // Chemin relatif pour les fichiers PDF
                        if (file_exists($file_path)):
                        ?>
                            <a href="<?php echo htmlspecialchars($file_path); ?>" target="_blank">
                                <img src="img/pdf.jpg" alt="PDF"> <!-- Utilisez l'image PDF pour chaque cours -->
                                <p><?php echo htmlspecialchars($pdf['titre']); ?></p>
                            </a>
                        <?php else: ?>
                            <p>Le fichier PDF n'a pas été trouvé.</p>
                        <?php endif; ?>
                    <?php else: ?>
                        <p>Le nom du fichier PDF n'est pas spécifié.</p>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
        <!-- Pagination -->
        <div class="pagination">
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <a href="?page=<?php echo $i; ?>" <?php if ($i == $page_courante) echo 'class="active"'; ?>><?php echo $i; ?></a>
            <?php endfor; ?>
        </div>
    </div>
</body>
</html>
