<?php
require 'config.php';
session_start();

// Vérifiez si l'élève est connecté
if (!isset($_SESSION['eleve_id'])) {
    header('Location: connexion_eleve.php');
    exit;
}

try {
    // Récupérer l'ID du professeur assigné à l'élève connecté
    $stmt = $pdo->prepare("
        SELECT professeur_id 
        FROM eleves 
        WHERE id = ?
    ");
    $stmt->execute([$_SESSION['eleve_id']]);
    $eleve = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$eleve) {
        throw new Exception("Élève non trouvé.");
    }

    $professeur_id = $eleve['professeur_id'];

    // Récupérer les messages pour l'élève connecté envoyés uniquement par son professeur
    $stmt = $pdo->prepare("
        SELECT m.id, m.titre, m.contenu, m.date_envoi, p.nom_complet AS professeur
        FROM messages m
        JOIN professeurs p ON m.id_professeur = p.id
        WHERE m.id_professeur = ?
        ORDER BY m.date_envoi DESC
    ");
    $stmt->execute([$professeur_id]);
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Erreur : " . $e->getMessage();
    exit;
} catch (Exception $e) {
    echo "Erreur : " . $e->getMessage();
    exit;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Tableau de Bord Élève</title>
    <link rel="stylesheet" href="style.css"> <!-- Assurez-vous d'inclure votre fichier CSS ici -->
</head>
<body>
    <?php include 'menu.php'; ?> <!-- Inclure le menu -->

    <div class="content">
        <h1>Vos Messages</h1>

        <?php if (count($messages) > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>Professeur</th>
                        <th>Titre</th>
                        <th>Message</th>
                        <th>Date d'Envoi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($messages as $message): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($message['professeur']); ?></td>
                            <td><?php echo htmlspecialchars($message['titre']); ?></td>
                            <td><?php echo htmlspecialchars($message['contenu']); ?></td>
                            <td><?php echo htmlspecialchars($message['date_envoi']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>Aucun message trouvé.</p>
        <?php endif; ?>
    </div>
</body>
</html>
